// Copyright 2014 Google Inc. All Rights Reserved.

#include "Mutex.h"

Mutex::Mutex() {
    pthread_mutex_init(&mMutex, NULL);
}

Mutex::~Mutex() {
    pthread_mutex_destroy(&mMutex);
}

void Mutex::lock() {
    /*PRQA: Lint Message 454: This is intention. Mutex will be unlocked in Mutex::unlock() */
    /*lint -save -e454*/
    pthread_mutex_lock(&mMutex);
    /*lint -restore*/
}

void Mutex::unlock() {
    /*PRQA: Lint Message 455: This is intention. Mutex will be locked in Mutex::lock() */
    /*lint -save -e455*/
    pthread_mutex_unlock(&mMutex);
    /*lint -restore*/
}

Autolock::Autolock(Mutex* mutex) : mMutex(mutex) {
    mutex->lock();
}

Autolock::~Autolock() {
    mMutex->unlock();
}
